<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create pivot table for many-to-many relationship
        Schema::create('station_license_well_license', function (Blueprint $table) {
            $table->id();
            $table->foreignId('station_license_id')->constrained()->onDelete('cascade');
            $table->foreignId('well_license_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            // Add unique constraint to prevent duplicate entries
            $table->unique(['station_license_id', 'well_license_id'], 'station_well_unique');
        });

        // Remove the old well_license_number column from station_licenses table
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->dropColumn('well_license_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Restore the well_license_number column
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->string('well_license_number')->nullable()->after('station_name');
        });

        // Drop the pivot table
        Schema::dropIfExists('station_license_well_license');
    }
};
