<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Order - ResidentialGathering pivot table
        Schema::create('order_residential_gathering', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            $table->foreignId('residential_gathering_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['order_id', 'residential_gathering_id'], 'order_rg_unique');
        });

        // Association - ResidentialGathering pivot table
        Schema::create('association_residential_gathering', function (Blueprint $table) {
            $table->id();
            $table->foreignId('association_id')->constrained()->cascadeOnDelete();
            $table->foreignId('residential_gathering_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['association_id', 'residential_gathering_id'], 'association_rg_unique');
        });

        // WellLicense - ResidentialGathering pivot table
        Schema::create('residential_gathering_well_license', function (Blueprint $table) {
            $table->id();
            $table->foreignId('well_license_id')->constrained()->cascadeOnDelete();
            $table->foreignId('residential_gathering_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['well_license_id', 'residential_gathering_id'], 'well_license_rg_unique');
        });

        // StationLicense - ResidentialGathering pivot table
        Schema::create('residential_gathering_station_license', function (Blueprint $table) {
            $table->id();
            $table->foreignId('station_license_id')->constrained()->cascadeOnDelete();
            $table->foreignId('residential_gathering_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['station_license_id', 'residential_gathering_id'], 'station_license_rg_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('residential_gathering_station_license');
        Schema::dropIfExists('residential_gathering_well_license');
        Schema::dropIfExists('association_residential_gathering');
        Schema::dropIfExists('order_residential_gathering');
    }
};
