<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('residential_gatherings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('center_id')->constrained()->cascadeOnDelete();
            $table->string('type')->nullable();
            $table->integer('families_count')->default(0);
            $table->integer('population')->default(0);
            $table->timestamps();

            // Unique constraint on name and center_id
            $table->unique(['name', 'center_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('residential_gatherings');
    }
};
