<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('centers', function (Blueprint $table) {
            $table->dropColumn(['residential_name', 'residential_type', 'population']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('centers', function (Blueprint $table) {
            $table->integer('population')->nullable()->after('families_count');
            $table->text('residential_name')->nullable()->after('population');
            $table->text('residential_type')->nullable()->after('residential_name');
        });
    }
};
