<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Drop the existing unique constraint on license_number only
            $table->dropUnique('associations_license_number_unique');

            // Add composite unique constraint on license_number and type
            $table->unique(['license_number', 'type'], 'associations_license_number_type_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Drop the composite unique constraint
            $table->dropUnique('associations_license_number_type_unique');

            // Restore the original unique constraint on license_number only
            $table->unique('license_number', 'associations_license_number_unique');
        });
    }
};
