<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->foreignId('state_id')->nullable()->after('association_id')->constrained()->cascadeOnDelete();
            $table->foreignId('city_id')->nullable()->after('state_id')->constrained()->cascadeOnDelete();
            $table->foreignId('center_id')->nullable()->after('city_id')->constrained()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->dropForeign(['state_id']);
            $table->dropForeign(['city_id']);
            $table->dropForeign(['center_id']);
            $table->dropColumn(['state_id', 'city_id', 'center_id']);
        });
    }
};
