<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            $table->boolean('email_verified')->default(false)->after('email');
            $table->timestamp('email_verified_at')->nullable()->after('email_verified');
            $table->boolean('phone_verified')->default(false)->after('phone_number');
            $table->timestamp('phone_verified_at')->nullable()->after('phone_verified');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            $table->dropColumn(['email_verified', 'email_verified_at', 'phone_verified', 'phone_verified_at']);
        });
    }
};
