<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('station_licenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('association_id')->constrained()->onDelete('cascade');
            $table->string('station_name')->comment('اسم المحطة');
            $table->decimal('lat', 10, 8)->nullable()->comment('خط العرض');
            $table->decimal('lng', 11, 8)->nullable()->comment('خط الطول');
            $table->decimal('site_area', 10, 2)->nullable()->comment('مساحة الموقع (متر مربع)');
            $table->decimal('design_capacity', 10, 2)->nullable()->comment('الطاقة التصميمية (متر مكعب)');
            $table->boolean('has_environmental_permit')->default(false)->comment('هل يوجد تصريح تشغيلي من المركز الوطني للرقابة على الالتزام البيئي');
            $table->boolean('has_evaporation_ponds')->nullable()->comment('هل يوجد أحواض تبخير');
            $table->decimal('evaporation_ponds_area', 10, 2)->nullable()->comment('مساحة الاحواض');
            $table->date('operation_start_date')->comment('تاريخ بدء تشغيل المحطة');
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('station_licenses');
    }
};
