<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('well_licenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('association_id')->constrained()->onDelete('cascade');
            $table->foreignId('state_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('city_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('center_id')->nullable()->constrained()->nullOnDelete();
            $table->string('well_name')->comment('اسم البئر');
            $table->decimal('lat', 10, 8)->nullable()->comment('خط العرض');
            $table->decimal('lng', 11, 8)->nullable()->comment('خط الطول');
            $table->decimal('well_depth', 8, 2)->nullable()->comment('عمق البئر');
            $table->decimal('well_diameter', 8, 2)->nullable()->comment('قطر البئر');
            $table->decimal('pump_size', 8, 2)->nullable()->comment('حجم المضخة');
            $table->decimal('withdrawal_amount', 10, 2)->nullable()->comment('كمية السحب جالون/بالدقيقة');
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('well_licenses');
    }
};
