<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_charter_change_requests', function (Blueprint $table) {
            // Add fields for second approval stage
            $table->unsignedBigInteger('first_approved_by')->nullable()->after('reviewed_by');
            $table->text('first_approval_notes')->nullable()->after('first_approved_by');
            $table->timestamp('first_approved_at')->nullable()->after('first_approval_notes');

            $table->unsignedBigInteger('final_approved_by')->nullable()->after('first_approved_at');
            $table->text('final_approval_notes')->nullable()->after('final_approved_by');
            $table->timestamp('final_approved_at')->nullable()->after('final_approval_notes');

            // Add foreign key constraints
            $table->foreign('first_approved_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('final_approved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_charter_change_requests', function (Blueprint $table) {
            // Drop foreign key constraints first
            $table->dropForeign(['first_approved_by']);
            $table->dropForeign(['final_approved_by']);

            // Drop columns
            $table->dropColumn([
                'first_approved_by',
                'first_approval_notes',
                'first_approved_at',
                'final_approved_by',
                'final_approval_notes',
                'final_approved_at',
            ]);
        });
    }
};
