<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_charters', function (Blueprint $table) {
            $table->foreignId('service_provider_id')
                ->nullable()
                ->after('created_by')
                ->constrained('service_providers')
                ->onDelete('set null');

            // Add index for better performance
            $table->index('service_provider_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_charters', function (Blueprint $table) {
            $table->dropForeign(['service_provider_id']);
            $table->dropIndex(['service_provider_id']);
            $table->dropColumn('service_provider_id');
        });
    }
};
