<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('project_charter_service_provider');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::create('project_charter_service_provider', function (Blueprint $table) {
            $table->id();

            // Foreign key references
            $table->foreignId('project_charter_id')
                ->constrained('project_charters')
                ->onDelete('cascade');

            $table->foreignId('service_provider_id')
                ->constrained('service_providers')
                ->onDelete('cascade');

            $table->timestamps();

            // Ensure unique combination of project_charter_id and service_provider_id
            $table->unique(['project_charter_id', 'service_provider_id'], 'pc_sp_unique');

            // Add indexes for better performance
            $table->index('project_charter_id');
            $table->index('service_provider_id');
        });
    }
};
