<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_escalation_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_charter_id')->constrained()->cascadeOnDelete();
            $table->foreignId('risk_register_id')->nullable()->constrained()->nullOnDelete();
            $table->text('problem');
            $table->text('details');
            $table->enum('status', ['pending', 'resolved', 'escalated_to_level_2', 'resolved_level_2'])->default('pending');
            $table->foreignId('requested_by')->constrained('users');
            $table->foreignId('level_1_reviewed_by')->nullable()->constrained('users');
            $table->text('level_1_resolution_notes')->nullable();
            $table->timestamp('level_1_resolved_at')->nullable();
            $table->foreignId('level_2_reviewed_by')->nullable()->constrained('users');
            $table->text('level_2_resolution_notes')->nullable();
            $table->timestamp('level_2_resolved_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_escalation_requests');
    }
};
