<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_change_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_charter_id')->constrained()->onDelete('cascade');

            // Change request type: scope, duration, cost
            $table->enum('change_type', ['scope', 'duration', 'cost'])->comment('النطاق، المدة، التكلفة');

            // Status: pending, approved, rejected
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');

            // Common fields for all change types
            $table->text('justification')->comment('Justification for the change request');

            // Duration change fields
            $table->date('new_start_date')->nullable()->comment('New start date if duration changed');
            $table->date('new_end_date')->nullable()->comment('New end date if duration changed');
            $table->integer('additional_duration_days')->nullable()->comment('Additional days needed');

            // Cost change fields
            $table->decimal('additional_cost', 15, 2)->nullable()->comment('Additional cost amount');
            $table->text('cost_breakdown')->nullable()->comment('Breakdown of additional costs');

            // Scope change fields (can also include duration and cost changes)
            $table->text('scope_changes')->nullable()->comment('Description of scope changes');
            $table->boolean('includes_duration_change')->default(false)->comment('Whether scope change includes duration change');
            $table->boolean('includes_cost_change')->default(false)->comment('Whether scope change includes cost change');

            // Review fields
            $table->foreignId('requested_by')->constrained('users');
            $table->foreignId('reviewed_by')->nullable()->constrained('users');
            $table->text('review_notes')->nullable();
            $table->timestamp('reviewed_at')->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['project_charter_id', 'status']);
            $table->index(['change_type', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_change_requests');
    }
};
