<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_donor_financial_portfolio', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('donor_financial_portfolio_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            // Ensure a user can only be linked to a portfolio once
            $table->unique(['user_id', 'donor_financial_portfolio_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_donor_financial_portfolio');
    }
};
