<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('association_registrations', function (Blueprint $table) {
            if (Schema::hasColumn('association_registrations', 'hashed_otp')) {
                $table->dropColumn('hashed_otp');
            }
            if (Schema::hasColumn('association_registrations', 'otp_expires_at')) {
                $table->dropColumn('otp_expires_at');
            }
            if (Schema::hasColumn('association_registrations', 'otp_attempts')) {
                $table->dropColumn('otp_attempts');
            }
        });
    }

    public function down(): void
    {
        Schema::table('association_registrations', function (Blueprint $table) {
            $table->string('hashed_otp')->nullable();
            $table->dateTime('otp_expires_at')->nullable();
            $table->unsignedTinyInteger('otp_attempts')->default(0);
        });
    }
};
