<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('association_registrations', function (Blueprint $table) {
            // Allow draft rows to be created before user fills data
            $table->string('name')->nullable()->change();
            $table->string('license_number')->nullable()->change();
            $table->date('license_expiration_date')->nullable()->change();
            $table->string('representative_full_name')->nullable()->change();
            $table->string('representative_position')->nullable()->change();
            $table->string('phone_number')->nullable()->change();
            $table->string('email')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('association_registrations', function (Blueprint $table) {
            // Revert to NOT NULL (may fail if nulls exist; ensure cleanup before rolling back)
            $table->string('name')->nullable(false)->change();
            $table->string('license_number')->nullable(false)->change();
            $table->date('license_expiration_date')->nullable(false)->change();
            $table->string('representative_full_name')->nullable(false)->change();
            $table->string('representative_position')->nullable(false)->change();
            $table->string('phone_number')->nullable(false)->change();
            $table->string('email')->nullable(false)->change();
        });
    }
};
