<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('association_registrations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('license_number');
            $table->date('license_expiration_date');
            $table->string('representative_full_name');
            $table->string('representative_position');
            $table->string('phone_number');
            $table->string('email')->index();
            $table->string('status')->default('pending_verification');
            $table->string('hashed_otp')->nullable();
            $table->dateTime('otp_expires_at')->nullable();
            $table->unsignedTinyInteger('otp_attempts')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('association_registrations');
    }
};
