<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('donor_financial_portfolios', function (Blueprint $table) {
            $table->decimal('operating_percentage', 5, 2)
                ->nullable()
                ->after('balance')
                ->comment('Operating percentage for the portfolio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('donor_financial_portfolios', function (Blueprint $table) {
            $table->dropColumn('operating_percentage');
        });
    }
};
