<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_charter_completion_requests', function (Blueprint $table) {
            // Add new closure-related fields
            $table->date('actual_end_date')->nullable()->after('reason');
            $table->longText('learned_lessons')->nullable()->after('actual_end_date');
            $table->text('notes')->nullable()->after('learned_lessons');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_charter_completion_requests', function (Blueprint $table) {
            // Remove the new fields
            $table->dropColumn([
                'actual_end_date',
                'learned_lessons',
                'notes',
            ]);
        });
    }
};
