<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_charter_deliverables', function (Blueprint $table) {
            $table->enum('file_status', ['pending', 'approved', 'rejected'])->nullable()->after('estimated_cost');
            $table->foreignId('approved_by')->nullable()->constrained('users')->onDelete('set null')->after('file_status');
            $table->timestamp('approved_at')->nullable()->after('approved_by');
            $table->text('rejection_reason')->nullable()->after('approved_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_charter_deliverables', function (Blueprint $table) {
            $table->dropColumn(['file_status', 'rejection_reason', 'approved_at']);
            $table->dropConstrainedForeignId('approved_by');
        });
    }
};
