<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add created_by column to completion_reports table
        Schema::table('completion_reports', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to donor_financial_portfolios table
        Schema::table('donor_financial_portfolios', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to initiative_operation_goals table
        Schema::table('initiative_operation_goals', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to initiative_projects table
        Schema::table('initiative_projects', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to initiative_results table
        Schema::table('initiative_results', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to order_agreements table
        Schema::table('order_agreements', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to order_finances table
        Schema::table('order_finances', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to order_requirements table
        Schema::table('order_requirements', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to performance_cards table
        Schema::table('performance_cards', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to performance_card_results table
        Schema::table('performance_card_results', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to project_charters table
        Schema::table('project_charters', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to project_charter_deliverables table
        Schema::table('project_charter_deliverables', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to project_charter_tasks table
        Schema::table('project_charter_tasks', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });

        // Add created_by column to risk_registers table
        Schema::table('risk_registers', function (Blueprint $table) {
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Drop created_by column from completion_reports table
        Schema::table('completion_reports', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from donor_financial_portfolios table
        Schema::table('donor_financial_portfolios', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from initiative_operation_goals table
        Schema::table('initiative_operation_goals', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from initiative_projects table
        Schema::table('initiative_projects', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from initiative_results table
        Schema::table('initiative_results', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from order_agreements table
        Schema::table('order_agreements', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from order_finances table
        Schema::table('order_finances', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from order_requirements table
        Schema::table('order_requirements', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from performance_cards table
        Schema::table('performance_cards', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from performance_card_results table
        Schema::table('performance_card_results', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from project_charters table
        Schema::table('project_charters', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from project_charter_deliverables table
        Schema::table('project_charter_deliverables', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from project_charter_tasks table
        Schema::table('project_charter_tasks', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });

        // Drop created_by column from risk_registers table
        Schema::table('risk_registers', function (Blueprint $table) {
            $table->dropConstrainedForeignId('created_by');
        });
    }
};
