<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('risk_registers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('charter_id')
                ->constrained('project_charters')
                ->onDelete('cascade');
            $table->string('incident_likelihood', 255)->nullable();
            $table->string('impact_level', 255)->nullable();
            $table->string('impact_on_cost', 255)->nullable();
            $table->string('impact_on_time', 255)->nullable();
            $table->text('mitigation_plan')->nullable();
            $table->text('contingency_plan')->nullable();
            $table->text('financial_contingency')->nullable();
            $table->text('technical_contingency')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('risk_registers');
    }
};
