<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Add new verification and lock columns
            $table->boolean('is_verified')->default(false)->after('account_holder_name');
            $table->boolean('is_locked')->default(false)->after('is_verified');

            // Remove the status column
            $table->dropColumn('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Remove the new columns
            $table->dropColumn(['is_verified', 'is_locked']);

            // Add back the status column
            $table->enum('status', ['pending', 'approved', 'rejected', 'suspended'])->default('pending');
        });
    }
};
