<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Remove old file path columns as we're moving to Spatie MediaLibrary
            $table->dropColumn([
                'logo',
                'authorization_letter',
                'license_certificate',
                'iban_certificate',
                'national_address_certificate',
                'governance_certificate',
                'financial_reports',
                'iban_certificate_path',
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('associations', function (Blueprint $table) {
            // Re-add the columns if needed to rollback
            $table->string('logo')->nullable();
            $table->string('authorization_letter')->nullable();
            $table->string('license_certificate')->nullable();
            $table->string('iban_certificate')->nullable();
            $table->string('national_address_certificate')->nullable();
            $table->string('governance_certificate')->nullable();
            $table->string('financial_reports')->nullable();
            $table->string('iban_certificate_path')->nullable();
        });
    }
};
