<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->decimal('estimated_cost', 15, 2)->default(0);
            $table->decimal('actual_cost', 15, 2)->default(0);
            $table->decimal('progress_percentage', 5, 2)->default(0); // 0.00 to 100.00

            // $table->date('completed_date')->nullable();
            // $table->integer('priority')->default(1); // 1 = low, 2 = medium, 3 = high, 4 = urgent
            // $table->text('notes')->nullable();

            $table->foreignId('project_charter_deliverable_id')->constrained()->onDelete('cascade');
            // $table->foreignId('assigned_user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();

            // $table->index(['status', 'due_date'], 'pct_status_due_date_idx');
            // $table->index(['project_charter_deliverable_id', 'status'], 'pct_deliverable_status_idx');
            // index of project_charter_deliverable_id
            $table->index(['project_charter_deliverable_id'], 'pct_deliverable_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_tasks');
    }
};
