<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_agreements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->string('contract_number')->unique()->comment('رقم العقد');
            $table->decimal('total_contract_value', 15, 2)->comment('القيمة الإجمالية للعقد');
            $table->date('start_date')->comment('تاريخ بداية العقد');
            $table->timestamps();

            // Ensure one-to-one relationship
            $table->unique('order_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_agreements');
    }
};
