<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_performance_card_result', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_charter_id')->constrained()->onDelete('cascade')->name('pc_pcr_charter_foreign');
            $table->foreignId('performance_card_result_id')->constrained()->onDelete('cascade')->name('pc_pcr_result_foreign');
            $table->timestamps();

            // Ensure unique combination
            $table->unique(['project_charter_id', 'performance_card_result_id'], 'pc_pcr_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_performance_card_result');
    }
};
