<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiative_result_pcr', function (Blueprint $table) {
            $table->id();
            $table->foreignId('initiative_result_id')->constrained('initiative_results')->onDelete('cascade');
            $table->foreignId('performance_card_result_id')->constrained('performance_card_results')->onDelete('cascade');
            $table->timestamps();

            // Ensure unique combination to prevent duplicates
            $table->unique(['initiative_result_id', 'performance_card_result_id'], 'ir_pcr_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiative_result_pcr');
    }
};
