<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiative_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('initiative_id')->constrained()->onDelete('cascade');
            $table->decimal('expected_q1', 15, 2)->nullable();
            $table->decimal('actual_q1', 15, 2)->nullable();
            $table->decimal('expected_q2', 15, 2)->nullable();
            $table->decimal('actual_q2', 15, 2)->nullable();
            $table->decimal('expected_q3', 15, 2)->nullable();
            $table->decimal('actual_q3', 15, 2)->nullable();
            $table->decimal('expected_q4', 15, 2)->nullable();
            $table->decimal('actual_q4', 15, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiative_results');
    }
};
