<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiative_operation_goals', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('performance_criteria');
            $table->text('target');
            $table->text('actual')->nullable();
            $table->foreignId('initiative_id')->constrained()->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiative_operation_goals');
    }
};
