<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_finances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('order_requirement_id')->constrained()->onDelete('cascade')->comment('مطلب الطلب المرتبط');
            $table->integer('count')->nullable()->comment('العدد');
            $table->string('capacity', 255)->nullable()->comment('السعة');
            $table->integer('execution_duration')->nullable()->comment('مدة التنفيذ');
            $table->string('company_name', 255)->nullable()->comment('اسم الشركة');
            $table->decimal('offer_price', 15, 2)->nullable()->comment('قيمة عرض السعر');
            $table->decimal('additional_fees', 15, 2)->nullable()->comment('رسوم اضافية');
            $table->decimal('operation_cost_percentage', 5, 2)->nullable()->comment('نسبة تكلفة التشغيل');
            $table->decimal('operation_cost', 15, 2)->nullable()->comment('تكلفة التشغيل');
            $table->timestamps();

            // Ensure that the order_requirement belongs to the same order
            $table->index(['order_id', 'order_requirement_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_finances');
    }
};
