<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_deliverables', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->date('expected_delivery_date')->nullable();
            $table->decimal('weight', 5, 2)->nullable(); // Weight out of 100 with 2 decimal places
            $table->string('payment_number')->nullable(); // Payment number if applicable
            $table->foreignId('project_charter_id')->constrained()->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_deliverables');
    }
};
