<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charters', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->date('start_date');
            $table->date('expected_end_date');
            $table->decimal('estimated_cost', 15, 2);
            $table->decimal('total_cost', 15, 2);
            $table->enum('status', ['draft', 'awaiting_approval', 'approved', 'rejected'])->default('draft');
            $table->foreignId('initiative_project_id')->unique()->constrained()->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charters');
    }
};
