<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiative_products', function (Blueprint $table) {
            $table->foreignId('initiative_id')->constrained()->onDelete('cascade');
            $table->foreignId('sekaya_value_id')->constrained()->onDelete('cascade');
            $table->primary(['initiative_id', 'sekaya_value_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiative_products');
    }
};
