<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiatives', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->date('start_date');
            $table->date('expected_end_date');
            $table->text('description')->nullable();
            $table->decimal('expected_cost', 15, 2)->nullable()->comment('التكلفة المتوقعة للمبادرة');
            $table->decimal('emergency_reserve', 15, 2)->nullable()->comment('الاحتياطي الطارئ للمبادرة');
            $table->foreignId('performance_wallet_id')->constrained()->onDelete('cascade');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiatives');
    }
};
