<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Pivot table for performance cards and products (sekaya_values)
        Schema::create('performance_card_sekaya_value', function (Blueprint $table) {
            $table->foreignId('performance_card_id')->constrained()->onDelete('cascade');
            $table->foreignId('sekaya_value_id')->constrained()->onDelete('cascade');
            $table->primary(['performance_card_id', 'sekaya_value_id']);
        });

        // Pivot table for performance cards and assignees (users)
        Schema::create('performance_card_user', function (Blueprint $table) {
            $table->foreignId('performance_card_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->primary(['performance_card_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('performance_card_user');
        Schema::dropIfExists('performance_card_sekaya_value');
    }
};
