<?php

use App\Models\Order;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('association_id')->constrained()->onDelete('cascade');
            $table->enum('type', [
                'STATION',
                'TANKER',
                'STORAGE_TANK',
                'CENTRAL_STORAGE_TANK',
                'MAINTENANCE_STATION',
                'MAINTENANCE_TANKER',
                'MICRO_NETWORK',
                'OTHER',
                'WELL_DRILLING',
                'RAINWATER_STORAGE',
                'HOME_FILTERS',
                'WATER_BOTTLES',
                'COOLERS',
                'PRODUCTS_UNDER_REVIEW',
            ])->default('STATION');
            $table->enum('status', [
                Order::STATUS_CREATED,
                Order::STATUS_PENDING_RECOMMENDATION,
                Order::STATUS_RECOMMENDED,
                Order::STATUS_TECHNICAL_FINANCIAL_REQUESTED,
                Order::STATUS_TECHNICAL_FINANCIAL_APPROVED,
                Order::STATUS_PROJECT_MANAGER_APPROVED,
                Order::STATUS_CLASSIFICATION,
                Order::STATUS_AGREEMENT,
                Order::STATUS_CEO_APPROVED,
                Order::STATUS_LAUNCHED,
                Order::STATUS_REJECTED,
            ])->default(Order::STATUS_PENDING_RECOMMENDATION);
            $table->decimal('lat', 10, 8)->nullable();
            $table->decimal('lng', 11, 8)->nullable();
            $table->integer('number_of_families')->nullable();
            $table->json('water_source')->nullable()->comment('Array of water sources: government, private, charity');
            $table->decimal('water_distance', 8, 2)->nullable();
            $table->text('order_justifications')->nullable();
            $table->text('order_description')->nullable();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
