<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('associations', function (Blueprint $table) {
            $table->id();

            $table->string('name', 255);
            $table->string('logo');

            $table->string('license_number', 255);
            $table->date('license_expiration_date');

            $table->string('representative_full_name', 255);
            $table->string('representative_position', 255);

            $table->string('phone_number', 20);
            $table->string('secondary_phone_number', 20)->nullable();
            $table->string('email', 255);

            $table->string('map_location')->nullable();
            $table->string('city')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('neighborhood')->nullable();
            $table->string('building_number')->nullable();
            $table->string('street')->nullable();
            $table->string('branch_number')->nullable();

            $table->json('regions')->nullable();
            $table->json('governorates')->nullable();
            $table->json('centers')->nullable();
            $table->json('villages')->nullable();

            $table->string('iban')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('account_holder_name')->nullable();
            $table->string('iban_certificate_path')->nullable();

            $table->string('authorization_letter')->nullable();
            $table->string('license_certificate')->nullable();
            $table->string('iban_certificate')->nullable();
            $table->string('national_address_certificate')->nullable();
            $table->string('governance_certificate')->nullable();
            $table->string('financial_reports')->nullable();

            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');

            $table->timestamps();
        });

        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('association_id')->nullable()->after('id');
            $table->foreign('association_id')
                ->references('id')
                ->on('associations')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['association_id']);
            $table->dropColumn('association_id');
        });
        Schema::dropIfExists('associations');
    }
};
