<?php

namespace Database\Factories;

use App\Models\State;
use Illuminate\Database\Eloquent\Factories\Factory;

class StateFactory extends Factory
{
    protected $model = State::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => [
                'ar' => $this->faker->city(),
                'en' => $this->faker->city(),
            ],
            'lat' => $this->faker->latitude(16, 32), // Saudi Arabia latitude range
            'lng' => $this->faker->longitude(34, 56), // Saudi Arabia longitude range
        ];
    }

    /**
     * State without coordinates
     */
    public function withoutCoordinates(): static
    {
        return $this->state(fn (array $attributes) => [
            'lat' => null,
            'lng' => null,
        ]);
    }
}
