<?php

namespace Database\Factories;

use App\Models\ProjectCharterDeliverable;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectCharterTask>
 */
class ProjectCharterTaskFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startDate = $this->faker->dateTimeBetween('-1 month', '+1 month');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 months');

        return [
            'name' => $this->faker->sentence(4),
            'description' => $this->faker->paragraph(2),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'estimated_cost' => $this->faker->numberBetween(1000, 50000),
            'actual_cost' => $this->faker->optional(0.6)->numberBetween(800, 60000),
            'progress_percentage' => $this->faker->numberBetween(0, 100),
            'project_charter_deliverable_id' => ProjectCharterDeliverable::factory(),
        ];
    }

    /**
     * Indicate that the task is completed.
     */
    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'progress_percentage' => 100,
            'actual_cost' => $this->faker->numberBetween(
                (int) ($attributes['estimated_cost'] * 0.8),
                (int) ($attributes['estimated_cost'] * 1.2)
            ),
        ]);
    }

    /**
     * Indicate that the task is overdue.
     */
    public function overdue(): static
    {
        return $this->state(fn (array $attributes) => [
            'end_date' => $this->faker->dateTimeBetween('-2 weeks', '-1 day'),
            'progress_percentage' => $this->faker->numberBetween(10, 70),
        ]);
    }

    /**
     * Indicate that the task is high cost.
     */
    public function highCost(): static
    {
        return $this->state(fn (array $attributes) => [
            'estimated_cost' => $this->faker->numberBetween(50000, 200000),
        ]);
    }

    /**
     * Indicate that the task is in progress.
     */
    public function inProgress(): static
    {
        return $this->state(fn (array $attributes) => [
            'progress_percentage' => $this->faker->numberBetween(10, 90),
            'actual_cost' => $this->faker->numberBetween(
                0,
                (int) ($attributes['estimated_cost'] * 0.8)
            ),
        ]);
    }
}
