<?php

namespace Database\Factories;

use App\Models\InitiativeProject;
use App\Models\Order;
use App\Models\ProjectCharter;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectCharterFactory extends Factory
{
    protected $model = ProjectCharter::class;

    public function definition(): array
    {
        $names = [
            'Water Quality Enhancement Project Charter',
            'Community Infrastructure Development Charter',
            'Emergency Response System Charter',
            'Sustainable Water Management Charter',
            'Technology Integration Charter',
            'Environmental Protection Charter',
            'Public Health Initiative Charter',
            'Regional Cooperation Charter',
        ];

        $startDate = $this->faker->dateTimeBetween('-6 months', '+2 months');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 years');
        $estimatedCost = $this->faker->randomFloat(2, 100000, 1000000);

        return [
            'name' => $this->faker->randomElement($names),
            'description' => $this->faker->paragraph(4),
            'start_date' => $startDate,
            'expected_end_date' => $endDate,
            'estimated_cost' => $estimatedCost,
            'total_cost' => $estimatedCost * $this->faker->randomFloat(2, 0.8, 1.2), // Variance from estimate
            'status' => $this->faker->randomElement([
                ProjectCharter::STATUS_DRAFT,
                ProjectCharter::STATUS_AWAITING_APPROVAL,
                ProjectCharter::STATUS_APPROVED,
                ProjectCharter::STATUS_REJECTED,
            ]),
            'initiative_project_id' => InitiativeProject::factory(),
            'order_id' => $this->faker->boolean(30) ? Order::factory() : null,
        ];
    }

    public function draft(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => ProjectCharter::STATUS_DRAFT,
        ]);
    }

    public function approved(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => ProjectCharter::STATUS_APPROVED,
        ]);
    }

    public function rejected(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => ProjectCharter::STATUS_REJECTED,
        ]);
    }

    public function awaitingApproval(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => ProjectCharter::STATUS_AWAITING_APPROVAL,
        ]);
    }

    public function withOrder(): static
    {
        return $this->state(fn (array $attributes) => [
            'order_id' => Order::factory(),
        ]);
    }

    public function withoutOrder(): static
    {
        return $this->state(fn (array $attributes) => [
            'order_id' => null,
        ]);
    }
}
