<?php

namespace Database\Factories;

use App\Models\ProjectCharter;
use App\Models\ProjectCharterDeliverable;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectCharterDeliverableFactory extends Factory
{
    protected $model = ProjectCharterDeliverable::class;

    public function definition(): array
    {
        $deliverableTypes = [
            'System Design Documentation',
            'Infrastructure Installation',
            'Water Quality Testing Report',
            'Community Training Program',
            'Maintenance Manual Development',
            'Environmental Compliance Report',
            'Performance Monitoring System',
            'Stakeholder Communication Plan',
            'Technical Specification Review',
            'Final Project Documentation',
        ];

        return [
            'project_charter_id' => ProjectCharter::factory(),
            'name' => $this->faker->randomElement($deliverableTypes),
            'description' => $this->faker->paragraph(2),
            'expected_delivery_date' => $this->faker->dateTimeBetween('now', '+1 year'),
            'weight' => $this->faker->randomFloat(2, 5, 40),
            'payment_number' => $this->faker->boolean(60) ? 'PAY-'.$this->faker->numerify('####') : null,
        ];
    }

    public function majorDeliverable(): static
    {
        return $this->state(fn (array $attributes) => [
            'weight' => $this->faker->randomFloat(2, 25, 50),
            'payment_number' => 'PAY-'.$this->faker->numerify('####'),
        ]);
    }

    public function milestone(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => $this->faker->randomElement([
                'Project Initiation Milestone',
                'Design Approval Milestone',
                'Installation Completion Milestone',
                'Testing and Validation Milestone',
                'Project Closure Milestone',
            ]),
            'weight' => $this->faker->randomFloat(2, 15, 35),
        ]);
    }

    public function critical(): static
    {
        return $this->state(fn (array $attributes) => [
            'expected_delivery_date' => $this->faker->dateTimeBetween('now', '+3 months'),
            'weight' => $this->faker->randomFloat(2, 20, 45),
        ]);
    }
}
