<?php

namespace Database\Factories;

use App\Models\PerformanceCard;
use App\Models\PerformanceWallet;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class PerformanceWalletFactory extends Factory
{
    protected $model = PerformanceWallet::class;

    public function definition(): array
    {
        $names = [
            'Water Quality Improvement Initiative',
            'Infrastructure Support Program',
            'Community Empowerment Initiative',
            'Strategic Investment Portfolio',
            'Emergency Response Fund',
            'Environmental Sustainability Program',
            'Technical Excellence Initiative',
            'Innovation and Research Portfolio',
        ];

        $startDate = $this->faker->dateTimeBetween('-6 months', 'now');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 years');

        return [
            'name' => $this->faker->randomElement($names),
            'start_date' => $startDate,
            'expected_end_date' => $endDate,
            'description' => $this->faker->paragraph(3),
            'performance_card_id' => PerformanceCard::factory(),
            'created_by' => User::factory(),
        ];
    }

    public function ongoing(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'expected_end_date' => $this->faker->dateTimeBetween('now', '+1 year'),
        ]);
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('-1 year', '-6 months'),
            'expected_end_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
        ]);
    }

    public function future(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('+1 month', '+6 months'),
            'expected_end_date' => $this->faker->dateTimeBetween('+6 months', '+2 years'),
        ]);
    }
}
