<?php

namespace Database\Factories;

use App\Models\PerformanceCard;
use App\Models\PerformanceCardResult;
use Illuminate\Database\Eloquent\Factories\Factory;

class PerformanceCardResultFactory extends Factory
{
    protected $model = PerformanceCardResult::class;

    public function definition(): array
    {
        $results = [
            'Installed 15 new filtration systems across the region',
            'Reduced contamination incidents by 40% compared to last quarter',
            'Achieved 98% water quality compliance rate',
            'Completed maintenance on 25 water stations',
            'Reduced system downtime by 35%',
            'Improved water pressure in 80% of service areas',
            'Trained 150 community members in water management',
            'Established 10 community water committees',
            'Distributed 500 water quality testing kits',
            'Secured $2M in funding for infrastructure expansion',
            'Identified 20 new strategic installation sites',
            'Developed 5-year water access improvement plan',
            'Deployed emergency water supplies to 5 crisis areas',
            'Reduced emergency response time by 60%',
            'Maintained 99.5% water availability during emergencies',
        ];

        return [
            'performance_card_id' => PerformanceCard::factory(),
            'result' => $this->faker->randomElement($results),
        ];
    }
}
