<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\PerformanceCard;
use Illuminate\Database\Eloquent\Factories\Factory;

class PerformanceCardFactory extends Factory
{
    protected $model = PerformanceCard::class;

    public function definition(): array
    {
        $goals = [
            'Improve water quality standards across all distribution centers by implementing advanced filtration systems',
            'Provide technical support and maintenance for existing water infrastructure',
            'Empower local communities with water management skills and knowledge',
            'Develop long-term investment strategies for water infrastructure expansion',
            'Establish rapid response capabilities for water emergencies and disaster relief',
            'Enhance environmental protection measures and sustainability practices',
            'Optimize operational efficiency through technology integration',
            'Conduct research on innovative water treatment and distribution methods',
        ];

        return [
            'department_id' => Department::factory(),
            'project_manner' => $this->faker->randomElement([
                PerformanceCard::PROJECT_MANNER_DEVELOPMENTAL,
                PerformanceCard::PROJECT_MANNER_SUPPORT,
                PerformanceCard::PROJECT_MANNER_EMPOWERMENT,
                PerformanceCard::PROJECT_MANNER_INVESTMENT,
            ]),
            'goal' => $this->faker->randomElement($goals),
        ];
    }

    public function developmental(): static
    {
        return $this->state(fn (array $attributes) => [
            'project_manner' => PerformanceCard::PROJECT_MANNER_DEVELOPMENTAL,
        ]);
    }

    public function support(): static
    {
        return $this->state(fn (array $attributes) => [
            'project_manner' => PerformanceCard::PROJECT_MANNER_SUPPORT,
        ]);
    }

    public function empowerment(): static
    {
        return $this->state(fn (array $attributes) => [
            'project_manner' => PerformanceCard::PROJECT_MANNER_EMPOWERMENT,
        ]);
    }

    public function investment(): static
    {
        return $this->state(fn (array $attributes) => [
            'project_manner' => PerformanceCard::PROJECT_MANNER_INVESTMENT,
        ]);
    }
}
