<?php

namespace Database\Factories;

use App\Models\Order;
use App\Models\OrderRequirement;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderRequirementFactory extends Factory
{
    protected $model = OrderRequirement::class;

    public function definition(): array
    {
        return [
            'order_id' => Order::factory(),
            'name' => $this->faker->randomElement([
                'Technical Specifications',
                'Environmental Impact Assessment',
                'Site Survey Report',
                'Water Quality Analysis',
                'Community Approval Letter',
                'Land Ownership Certificate',
                'Construction Permits',
                'Safety Compliance Report',
                'Financial Feasibility Study',
                'Maintenance Plan Documentation',
            ]),
            'status' => $this->faker->randomElement([
                OrderRequirement::STATUS_PENDING,
                OrderRequirement::STATUS_ACCEPTED,
                OrderRequirement::STATUS_REJECTED,
                OrderRequirement::STATUS_ASK_MODIFICATION,
            ]),
        ];
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => OrderRequirement::STATUS_PENDING,
        ]);
    }

    public function accepted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => OrderRequirement::STATUS_ACCEPTED,
        ]);
    }

    public function rejected(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => OrderRequirement::STATUS_REJECTED,
        ]);
    }

    public function needsModification(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => OrderRequirement::STATUS_ASK_MODIFICATION,
        ]);
    }
}
