<?php

namespace Database\Factories;

use App\Models\Order;
use App\Models\OrderFinance;
use App\Models\OrderRequirement;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderFinanceFactory extends Factory
{
    protected $model = OrderFinance::class;

    public function definition(): array
    {
        return [
            'order_id' => Order::factory(),
            'order_requirement_id' => OrderRequirement::factory(),
            'count' => $this->faker->numberBetween(1, 10),
            'capacity' => $this->faker->randomElement([
                '250L',
                '500L',
                '1000L',
                '2000L',
                '5000L',
                '10000L',
                '20000L',
                '50000L',
            ]),
            'execution_duration' => $this->faker->numberBetween(15, 365),
            'company_name' => $this->faker->company().' '.$this->faker->randomElement([
                'Engineering',
                'Construction',
                'Water Solutions',
                'Infrastructure',
                'Systems',
            ]),
            'offer_price' => $this->faker->randomFloat(2, 5000, 1000000),
            'additional_fees' => $this->faker->randomFloat(2, 500, 50000),
            'operation_cost_percentage' => $this->faker->randomFloat(2, 3, 20),
            'operation_cost' => $this->faker->randomFloat(2, 1000, 100000),
        ];
    }

    public function lowCost(): static
    {
        return $this->state(fn (array $attributes) => [
            'offer_price' => $this->faker->randomFloat(2, 5000, 50000),
            'additional_fees' => $this->faker->randomFloat(2, 500, 5000),
            'operation_cost' => $this->faker->randomFloat(2, 1000, 10000),
        ]);
    }

    public function highCost(): static
    {
        return $this->state(fn (array $attributes) => [
            'offer_price' => $this->faker->randomFloat(2, 500000, 2000000),
            'additional_fees' => $this->faker->randomFloat(2, 50000, 200000),
            'operation_cost' => $this->faker->randomFloat(2, 50000, 300000),
        ]);
    }

    public function mediumComplexity(): static
    {
        return $this->state(fn (array $attributes) => [
            'count' => $this->faker->numberBetween(3, 8),
            'execution_duration' => $this->faker->numberBetween(60, 180),
            'capacity' => $this->faker->randomElement(['5000L', '10000L', '20000L']),
        ]);
    }
}
