<?php

namespace Database\Factories;

use App\Models\Association;
use App\Models\Order;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderFactory extends Factory
{
    protected $model = Order::class;

    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement([
                Order::TYPE_STATION,
                Order::TYPE_TANKER,
                Order::TYPE_DOMESTIC_STORAGE_TANK,
                Order::TYPE_CENTRAL_STORAGE_TANK,
                Order::TYPE_MAINTENANCE_STATION,
                Order::TYPE_MAINTENANCE_TANKER,
                Order::TYPE_MICRO_NETWORK,
                Order::TYPE_OTHER,
                Order::TYPE_WELL_DRILLING,
                Order::TYPE_RAINWATER_STORAGE,
                Order::TYPE_HOME_FILTERS,
                Order::TYPE_WATER_BOTTLES,
                Order::TYPE_COOLERS,
                Order::TYPE_PRODUCTS_UNDER_REVIEW,
            ]),
            'status' => $this->faker->randomElement([
                Order::STATUS_CREATED,
                Order::STATUS_PENDING_RECOMMENDATION,
                Order::STATUS_RECOMMENDED,
                Order::STATUS_TECHNICAL_FINANCIAL_REQUESTED,
                Order::STATUS_TECHNICAL_FINANCIAL_APPROVED,
                Order::STATUS_CLASSIFICATION,
            ]),
            'number_of_families' => $this->faker->numberBetween(10, 500),
            'water_distance' => $this->faker->randomFloat(2, 0.5, 15.0),
            'order_justifications' => $this->faker->paragraph(),
            'order_description' => $this->faker->paragraphs(2, true),
            'water_source' => $this->faker->randomElements([
                Order::WATER_SOURCE_GOVERNMENT,
                Order::WATER_SOURCE_PRIVATE,
                Order::WATER_SOURCE_CHARITY,
            ], $this->faker->numberBetween(1, 3)),
            'lat' => $this->faker->latitude(),
            'lng' => $this->faker->longitude(),
            'association_id' => Association::factory(),
            'created_by' => User::factory(),
        ];
    }
}
