<?php

namespace Database\Factories;

use App\Models\Order;
use App\Models\OrderAgreement;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderAgreementFactory extends Factory
{
    protected $model = OrderAgreement::class;

    public function definition(): array
    {
        return [
            'order_id' => Order::factory(),
            'contract_number' => 'CNT-'.date('Y').'-'.$this->faker->unique()->numerify('####'),
            'total_contract_value' => $this->faker->randomFloat(2, 50000, 2000000),
            'start_date' => $this->faker->dateTimeBetween('-1 month', '+2 months'),
        ];
    }

    public function highValue(): static
    {
        return $this->state(fn (array $attributes) => [
            'total_contract_value' => $this->faker->randomFloat(2, 1000000, 5000000),
        ]);
    }

    public function emergencyContract(): static
    {
        return $this->state(fn (array $attributes) => [
            'contract_number' => 'EMRG-'.date('Y').'-'.$this->faker->unique()->numerify('####'),
            'start_date' => $this->faker->dateTimeBetween('-1 week', 'now'),
        ]);
    }

    public function futureContract(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('+1 month', '+6 months'),
        ]);
    }
}
